import os
import sqlite3
import contextlib


def check_bible(filename: str):
    with contextlib.closing(sqlite3.connect(filename)) as connection:
        cursor = connection.execute("select * from bible where btext like '%침례%';")
        items = cursor.fetchall()
        return len(items)


def update_bible(filename: str):
    with contextlib.closing(sqlite3.connect(filename)) as connection:
        connection.execute("update bible set btext = replace(btext, '침례', '세례') where btext like '%침례%';")
        connection.execute("update bible set btext = replace(btext, '浸禮', '洗禮') where btext like '%浸禮%';")
        connection.commit()


def check_commentary(filename: str):
    with contextlib.closing(sqlite3.connect(filename)) as connection:
        cursor = connection.execute("select * from bible where btext like '%세례(세례)%';")
        items = cursor.fetchall()
        return len(items)


def update_commentary(filename: str):
    with contextlib.closing(sqlite3.connect(filename)) as connection:
        connection.execute("update bible set btext = replace(btext, '침례', '세례') where btext like '%침례%';")
        connection.execute("update bible set btext = replace(btext, '浸禮', '洗禮') where btext like '%浸禮%';")
        connection.execute("update bible set btext = replace(btext, '세례(세례)', '세례(침례)') where btext like '%세례(세례)%';")
        connection.execute("update bible set btext = replace(btext, '세례(洗禮, 침례(浸禮))', '세례(洗禮)') where btext like '%세례(洗禮)%';")
        connection.commit()


def check_dictionary(filename: str):
    with contextlib.closing(sqlite3.connect(filename)) as connection:
        cursor = connection.execute("select * from lexicon where dtext like '%세례(세례)%';")
        items = cursor.fetchall()
        return len(items)


def update_dictionary(filename: str):
    with contextlib.closing(sqlite3.connect(filename)) as connection:
        connection.execute("update lexicon set dtext = replace(dtext, '침례', '세례') where dtext like '%침례%';")
        connection.execute("update lexicon set dtext = replace(dtext, '세례(세례)', '세례(침례)') where dtext like '%세례(세례)%';")
        connection.commit()


def main():
    for filename in os.listdir():
        if filename.endswith('.dct'):
            update_dictionary(filename)
            print(3, filename, check_dictionary(filename))
        elif filename.endswith('.cdb'):
            update_commentary(filename)
            print(2, filename, check_commentary(filename))
        elif (filename.endswith('.bdb') or filename.endswith('.sdb')) and not filename[0].isascii():
            update_bible(filename)
            print(1, filename, check_bible(filename))


if __name__ == '__main__':
    main()
